/*:
 * @target MZ
 * @plugindesc Makes map transfers instant without any fade out or fade in effects.
 * @help This plugin overrides the default transfer behavior to make map transfers instant.
 */

(() => {
    const _Game_Player_performTransfer = Game_Player.prototype.performTransfer;
    Game_Player.prototype.performTransfer = function() {
        if (this.isTransferring()) {
            const mapId = this._newMapId;
            const x = this._newX;
            const y = this._newY;
            const d = this._newDirection;

            // Ensure the map data is loaded before transferring
            if ($dataMap) {
                this.executeTransfer(mapId, x, y, d);
            } else {
                // Wait until the map data is available
                DataManager.loadMapData(mapId);
                this._waitForMapData = true;
            }
        }
    };

    Game_Player.prototype.executeTransfer = function(mapId, x, y, d) {
        $gameMap.setup(mapId);
        this._x = x;
        this._y = y;
        this._realX = x;
        this._realY = y;
        this.setDirection(d);
        this._transferring = false;
        this.refresh();
        $gameMap.requestRefresh();
    };

    const _Scene_Map_updateMain = Scene_Map.prototype.updateMain;
    Scene_Map.prototype.updateMain = function() {
        if ($gamePlayer._waitForMapData && $dataMap) {
            const mapId = $gamePlayer._newMapId;
            const x = $gamePlayer._newX;
            const y = $gamePlayer._newY;
            const d = $gamePlayer._newDirection;
            $gamePlayer.executeTransfer(mapId, x, y, d);
            $gamePlayer._waitForMapData = false;
        }
        _Scene_Map_updateMain.call(this);
    };

    const _Game_Player_reserveTransfer = Game_Player.prototype.reserveTransfer;
    Game_Player.prototype.reserveTransfer = function(mapId, x, y, d) {
        _Game_Player_reserveTransfer.call(this, mapId, x, y, d);
        this._transferring = true;
        this._waitForMapData = false;
    };
})();
